<?php

// phpcs:disable Yoast.NamingConventions.NamespaceName.TooLong
namespace Yoast\WP\SEO\Llms_Txt\Application\Markdown_Builders;

use Yoast\WP\SEO\Llms_Txt\Domain\Markdown\Sections\Intro;

/**
 * The builder of the intro section.
 */
class Intro_Builder {

	/**
	 * Gets the plugin version that generated the llms.txt file.
	 *
	 * @return string The plugin version that generated the llms.txt file.
	 */
	protected function get_generator_version(): string {
		return 'Yoast SEO v' . \WPSEO_VERSION;
	}

	/**
	 * Builds the intro section.
	 *
	 * @return Intro The intro section.
	 */
	public function build_intro(): Intro {
		$intro_content = \sprintf(
			'Generated by %s, this is an llms.txt file, meant for consumption by LLMs.',
			$this->get_generator_version()
		);

		return new Intro( $intro_content, [] );
	}
}
