<?php
/**
 * Page: jetpack-forms-responses
 * Auto-generated by build process.
 * Do not edit this file manually.
 *
 * @package jetpack_forms
 */

// Global storage for jetpack-forms-responses routes and menu items
global $jetpack_forms_jetpack_forms_responses_routes, $jetpack_forms_jetpack_forms_responses_menu_items;
$jetpack_forms_jetpack_forms_responses_routes     = array();
$jetpack_forms_jetpack_forms_responses_menu_items = array();

if ( ! function_exists( 'jetpack_forms_register_jetpack_forms_responses_route' ) ) {
	/**
	 * Register a route for the jetpack-forms-responses page.
	 *
	 * @param string      $path           Route path (e.g., '/types/$type/edit/$id').
	 * @param string|null $content_module Script module ID for content (stage/inspector).
	 * @param string|null $route_module   Script module ID for route lifecycle hooks.
	 */
	function jetpack_forms_register_jetpack_forms_responses_route( $path, $content_module = null, $route_module = null ) {
		global $jetpack_forms_jetpack_forms_responses_routes;

		$route = array( 'path' => $path );
		if ( ! empty( $content_module ) ) {
			$route['content_module'] = $content_module;
		}
		if ( ! empty( $route_module ) ) {
			$route['route_module'] = $route_module;
		}

		$jetpack_forms_jetpack_forms_responses_routes[] = $route;
	}
}

if ( ! function_exists( 'jetpack_forms_register_jetpack_forms_responses_menu_item' ) ) {
	/**
	 * Register a menu item for the jetpack-forms-responses page.
	 *
	 * @param string $id          Menu item ID.
	 * @param string $label       Display label.
	 * @param string $to          Route path to navigate to.
	 * @param string $parent_id   Optional. Parent menu item ID.
	 * @param string $parent_type Optional. Parent type: 'drilldown' or 'dropdown'.
	 */
	function jetpack_forms_register_jetpack_forms_responses_menu_item( $id, $label, $to, $parent_id = '', $parent_type = '' ) {
		global $jetpack_forms_jetpack_forms_responses_menu_items;

		$menu_item = array(
			'id'    => $id,
			'label' => $label,
			'to'    => $to,
		);

		if ( ! empty( $parent_id ) ) {
			$menu_item['parent'] = $parent_id;
		}

		if ( ! empty( $parent_type ) && in_array( $parent_type, array( 'drilldown', 'dropdown' ), true ) ) {
			$menu_item['parent_type'] = $parent_type;
		}

		$jetpack_forms_jetpack_forms_responses_menu_items[] = $menu_item;
	}
}

if ( ! function_exists( 'jetpack_forms_get_jetpack_forms_responses_routes' ) ) {
	/**
	 * Get all registered routes for the jetpack-forms-responses page.
	 *
	 * @return array Array of route objects.
	 */
	function jetpack_forms_get_jetpack_forms_responses_routes() {
		global $jetpack_forms_jetpack_forms_responses_routes;
		return $jetpack_forms_jetpack_forms_responses_routes ?? array();
	}
}

if ( ! function_exists( 'jetpack_forms_get_jetpack_forms_responses_menu_items' ) ) {
	/**
	 * Get all registered menu items for the jetpack-forms-responses page.
	 *
	 * @return array Array of menu item objects.
	 */
	function jetpack_forms_get_jetpack_forms_responses_menu_items() {
		global $jetpack_forms_jetpack_forms_responses_menu_items;
		return $jetpack_forms_jetpack_forms_responses_menu_items ?? array();
	}
}

if ( ! function_exists( 'jetpack_forms_jetpack_forms_responses_preload_data' ) ) {
	/**
	 * Preload REST API data for the jetpack-forms-responses page.
	 * Automatically called during page rendering.
	 */
	function jetpack_forms_jetpack_forms_responses_preload_data() {
		// Define paths to preload - same for all pages
		// Please also change packages/core-data/src/entities.js when changing this.
		$preload_paths = array(
			'/?_fields=description,gmt_offset,home,image_sizes,image_size_threshold,image_output_formats,jpeg_interlaced,png_interlaced,gif_interlaced,name,site_icon,site_icon_url,site_logo,timezone_string,url,page_for_posts,page_on_front,show_on_front',
			array( '/wp/v2/settings', 'OPTIONS' ),
		);

		// Use rest_preload_api_request to gather the preloaded data
		$preload_data = array_reduce(
			$preload_paths,
			'rest_preload_api_request',
			array()
		);

		// Register the preloading middleware with wp-api-fetch
		wp_add_inline_script(
			'wp-api-fetch',
			sprintf(
				'wp.apiFetch.use( wp.apiFetch.createPreloadingMiddleware( %s ) );',
				wp_json_encode( $preload_data )
			),
			'after'
		);
	}
}

if ( ! function_exists( 'jetpack_forms_jetpack_forms_responses_render_page' ) ) {
	/**
	 * Render the jetpack-forms-responses page.
	 * Call this function from add_menu_page or add_submenu_page.
	 */
	function jetpack_forms_jetpack_forms_responses_render_page() {
		// Load build constants
		$build_constants = require __DIR__ . '/../../constants.php';

		// Set current screen
		set_current_screen();

		// Remove unwanted deprecated handler
		remove_action( 'admin_head', 'wp_admin_bar_header' );

		// Remove unwanted scripts and styles that were enqueued during `admin_init`
		foreach ( wp_scripts()->queue as $script ) {
			wp_dequeue_script( $script );
		}
		foreach ( wp_styles()->queue as $style ) {
			wp_dequeue_style( $style );
		}

		// Fire init action for extensions to register routes and menu items
		do_action( 'jetpack-forms-responses_init' );

		// Enqueue command palette assets for boot-based pages
		if ( function_exists( 'wp_enqueue_command_palette_assets' ) ) {
			wp_enqueue_command_palette_assets();
		}

		// Preload REST API data
		jetpack_forms_jetpack_forms_responses_preload_data();

		// Get all registered routes and menu items
		$menu_items = jetpack_forms_get_jetpack_forms_responses_menu_items();
		$routes = jetpack_forms_get_jetpack_forms_responses_routes();

		// Get boot module asset file for dependencies
		$asset_file = __DIR__ . '/../../modules/boot/index.min.asset.php';
		if ( file_exists( $asset_file ) ) {
			$asset = require $asset_file;

			// This script serves two purposes:
			// 1. It ensures all the globals that are made available to the modules are loaded.
			// 2. It initializes the boot module as an inline script.
			wp_register_script( 'jetpack-forms-responses-prerequisites', '', $asset['dependencies'], $asset['version'], true );

			// Add inline script to initialize the app
			$init_modules = [];
			wp_add_inline_script(
				'jetpack-forms-responses-prerequisites',
				sprintf(
					'import("@wordpress/boot").then(mod => mod.init({mountId: "%s", menuItems: %s, routes: %s, initModules: %s, dashboardLink: "%s"}));',
					'jetpack-forms-responses-app',
					wp_json_encode( $menu_items, JSON_HEX_TAG | JSON_UNESCAPED_SLASHES ),
					wp_json_encode( $routes, JSON_HEX_TAG | JSON_UNESCAPED_SLASHES ),
					wp_json_encode( $init_modules, JSON_HEX_TAG | JSON_UNESCAPED_SLASHES ),
					esc_url( admin_url( '/' ) )
				)
			);

			// Register prerequisites style by filtering script dependencies to find registered styles
			$style_dependencies = array_filter(
				$asset['dependencies'],
				function ( $handle ) {
					return wp_style_is( $handle, 'registered' );
				}
			);
			wp_register_style( 'jetpack-forms-responses-prerequisites', false, $style_dependencies, $asset['version'] );

			// Build dependencies for jetpack-forms-responses module
			$boot_dependencies = array(
				array(
					'import' => 'static',
					'id'     => '@wordpress/boot',
				),
			);

			// Add init modules as static dependencies
			// No init modules configured

			// Add all registered routes as dependencies
			foreach ( $routes as $route ) {
				if ( isset( $route['route_module'] ) ) {
					$boot_dependencies[] = array(
						'import' => 'static',
						'id'     => $route['route_module'],
					);
				}
				if ( isset( $route['content_module'] ) ) {
					$boot_dependencies[] = array(
						'import' => 'dynamic',
						'id'     => $route['content_module'],
					);
				}
			}

			// Dummy script module to ensure dependencies are loaded
			wp_register_script_module(
				'jetpack-forms-responses',
				$build_constants['build_url'] . 'pages/jetpack-forms-responses/loader.js',
				$boot_dependencies
			);

			// Enqueue the boot scripts and styles
			wp_enqueue_script( 'jetpack-forms-responses-prerequisites' );
			wp_enqueue_script_module( 'jetpack-forms-responses' );
			wp_enqueue_style( 'jetpack-forms-responses-prerequisites' );
		}

		// Output the HTML
		?>
		<!DOCTYPE html>
		<html <?php language_attributes(); ?>>
		<head>
			<meta charset="<?php bloginfo( 'charset' ); ?>">
			<meta name="viewport" content="width=device-width, initial-scale=1">
			<title><?php echo esc_html( get_admin_page_title() ); ?></title>
			<style>
				html {
					background: #f1f1f1;
					color: #444;
					font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
					font-size: 13px;
					line-height: 1.4em;
				}
				body {
					margin: 0;
				}
				#wpadminbar { display: none; }
			</style>
		<?php
		global $hook_suffix;
		// phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
		$hook_suffix = 'jetpack-forms-responses';

		// BEGIN see wp-admin/admin-header.php
		print_admin_styles();
		print_head_scripts();

		/**
		 * Fires in head section for a specific admin page.
		 *
		 * @since 2.1.0
		 */
		do_action( "admin_head-{$hook_suffix}" ); // phpcs:ignore WordPress.NamingConventions.ValidHookName.UseUnderscores

		/**
		 * Fires in head section for all admin pages.
		 *
		 * @since 2.1.0
		 */
		do_action( 'admin_head' );
		// END see wp-admin/admin-header.php
		?>
		</head>
		<body class="jetpack-forms-responses">
			<div id="jetpack-forms-responses-app" style="height: 100vh; box-sizing: border-box;"></div>
		<?php
		// BEGIN see wp-admin/admin-footer.php

		/**
		 * Prints scripts or data before the default footer scripts.
		 *
		 * @since 1.2.0
		 */
		do_action( 'admin_footer', '' );

		// Print import map first so it's available for inline scripts
		wp_script_modules()->print_import_map();
		print_footer_scripts();
		wp_script_modules()->print_enqueued_script_modules();
		wp_script_modules()->print_script_module_preloads();
		wp_script_modules()->print_script_module_data();

		/**
		 * Prints scripts or data after the default footer scripts.
		 *
		 * @since 2.8.0
		 */
		do_action( "admin_footer-{$hook_suffix}" ); // phpcs:ignore WordPress.NamingConventions.ValidHookName.UseUnderscores
		// END see wp-admin/admin-footer.php
		?>
		</body>
		</html>
		<?php
		exit;
	}
}

if ( ! function_exists( 'jetpack_forms_jetpack_forms_responses_intercept_render' ) ) {
	/**
	 * Intercept admin_init to render the page early.
	 * This bypasses the default WordPress admin template.
	 */
	function jetpack_forms_jetpack_forms_responses_intercept_render() {
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended
		if ( isset( $_GET['page'] ) && 'jetpack-forms-responses' === $_GET['page'] ) {
			jetpack_forms_jetpack_forms_responses_render_page();
			exit;
		}
	}
}

// Hook the interceptor to admin_init
add_action( 'admin_init', 'jetpack_forms_jetpack_forms_responses_intercept_render' );
