# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [4.2.44] - 2026-03-02
### Changed
- Update dependencies. [#46758]

## [4.2.43] - 2026-02-26
### Changed
- Update package dependencies. [#47285] [#47300] [#47309]

## [4.2.42] - 2026-02-23
### Changed
- Convert testimonial and connection screen images from PNG to WebP. [#47085]
- Update package dependencies. [#47173]

### Removed
- Remove outdated "Restore points created with every edit" notice from the Backup admin page. [#47216]

## [4.2.41] - 2026-02-16
### Changed
- Update package dependencies. [#47099]

### Fixed
- Compatibility: Clean up deprecated CSS. [#47067]

## [4.2.40] - 2026-02-10
### Changed
- Update package dependencies. [#46905] [#47002]

## [4.2.39] - 2026-02-02
### Changed
- Update package dependencies. [#46854]

## [4.2.38] - 2026-01-26
### Changed
- Update dependencies. [#46741]

## [4.2.37] - 2026-01-19
### Changed
- Update package dependencies. [#46552] [#46647]

## [4.2.36] - 2026-01-12
### Changed
- Update package dependencies. [#46456]

## [4.2.35] - 2025-12-22
### Changed
- Update package dependencies. [#46362]

## [4.2.34] - 2025-12-15
### Changed
- Update dependencies. [#46271]

## [4.2.33] - 2025-12-08
### Fixed
- Ensure proper flags are used with `json_encode()`. [#46092]

## [4.2.32] - 2025-12-01
### Changed
- Update package dependencies. [#46143]

## [4.2.31] - 2025-11-20
### Changed
- Update package dependencies. [#46022]

### Fixed
- Phan: Address PhanPossiblyUndeclaredVariable violations. [#45911]

## [4.2.30] - 2025-11-18
### Changed
- Update dependencies. [#45553]

## [4.2.29] - 2025-11-17
### Changed
- Update package dependencies. [#45915] [#45932] [#45958]

## [4.2.28] - 2025-11-10
### Changed
- Update package dependencies. [#45737] [#45756]

## [4.2.27] - 2025-11-03
### Changed
- Update package dependencies. [#45652]

## [4.2.26] - 2025-10-20
### Changed
- Update dependencies. [#45488]

## [4.2.25] - 2025-10-06
### Changed
- Update package dependencies. [#45334] [#45335]

## [4.2.24] - 2025-09-29
### Changed
- Update dependencies. [#44940]

## [4.2.23] - 2025-09-22
### Changed
- Update dependencies. [#44940]

## [4.2.22] - 2025-09-19
### Changed
- Update package dependencies. [#45173] [#45229]

## [4.2.21] - 2025-09-15
### Changed
- Update dependencies. [#44940]

## [4.2.20] - 2025-09-08
### Changed
- Update package dependencies. [#45027] [#45097]

## [4.2.19] - 2025-09-01
### Changed
- Update dependencies. [#44940]

## [4.2.18] - 2025-08-25
### Changed
- Update dependencies. [#44934]

## [4.2.17] - 2025-08-18
### Added
- Add `typecheck` script to ensure that TypeScript files are type-checked. [#44795]

## [4.2.16] - 2025-08-14
### Changed
- Update package dependencies. [#44701]

## [4.2.15] - 2025-08-11
### Changed
- Update package dependencies. [#44677]

### Fixed
- I18n: Improve context hints in comments for translators. [#44686]

## [4.2.14] - 2025-08-04
### Changed
- Update dependencies. [#44551]

## [4.2.13] - 2025-07-28
### Changed
- Internal updates.

## [4.2.12] - 2025-07-21
### Changed
- Update package dependencies. [#44356]

## [4.2.11] - 2025-07-14
### Changed
- Update package dependencies. [#44217] [#44219]

## [4.2.10] - 2025-07-07
### Changed
- Update package dependencies. [#44148] [#44151]

## [4.2.9] - 2025-06-30
### Changed
- Update dependencies. [#43971]

## [4.2.8] - 2025-06-27
### Fixed
- Fix PHP fatals on WP_Error. [#43388]

## [4.2.7] - 2025-06-24
### Changed
- Update dependencies. [#43971]

## [4.2.6] - 2025-06-23
### Changed
- Update package dependencies. [#44020]

## [4.2.5] - 2025-06-16
### Changed
- Update dependencies. [#43878]

## [4.2.4] - 2025-06-05
### Changed
- Update package dependencies. [#43718] [#43734] [#43766]

## [4.2.3] - 2025-06-02
### Changed
- Internal updates.

## [4.2.2] - 2025-05-26
### Changed
- Update dependencies. [#43569] [#43578]

## [4.2.1] - 2025-05-19
### Changed
- Update package dependencies. [#43398]

## [4.2.0] - 2025-05-12
### Changed
- Stable release management: Do not ship source files. [#43310]
- Update package dependencies. [#43400]
- Use `formatCurrency()` and `getCurrencyObject()` functions from the `@automattic/number-formatters` package. [#42796]

## [4.1.2] - 2025-05-05
### Changed
- Update package dependencies. [#43326] [#43356]

### Fixed
- Linting: Address final rules in WordPress Stylelint config. [#43296]
- Linting: Do additional stylesheet cleanup. [#43247]

## [4.1.1] - 2025-04-28
### Fixed
- Linting: Fix more Stylelint violations. [#43213]
- Linting: Remove outdated vendor prefixes in stylesheets. [#43219]

## [4.1.0] - 2025-04-21
### Added
- Sync: Add `jetpack_sync_active_modules` callable to whitelist of must-sync callables. [#43134]

## [4.0.22] - 2025-04-14
### Fixed
- Linting: Update stylesheets to use WordPress rules for fonts and colors. [#42920] [#42928]
- Linting: Use double colon notation for pseudo-element selectors. [#43019]

## [4.0.21] - 2025-04-07
### Changed
- Linting: First pass of style coding standards. [#42734]

## [4.0.20] - 2025-04-03
### Changed
- Update package dependencies. [#42762] [#42809]

## [4.0.19] - 2025-03-31
### Changed
- Update dependencies. [#42678]

## [4.0.18] - 2025-03-24
### Changed
- Update dependencies. [#42565]

## [4.0.17] - 2025-03-18
### Changed
- Update package dependencies. [#42511]

### Fixed
- Admin menu: Prevent PHP warnings by moving backup admin menu addition to a function hooked into `admin_menu`. [#42396]

## [4.0.16] - 2025-03-17
### Changed
- Update dependencies. [#42498]

## [4.0.15] - 2025-03-12
### Added
- Provide connection data to footer component. [#42000]

### Changed
- Update package dependencies. [#42384]

## [4.0.14] - 2025-03-10
### Changed
- Internal updates.

## [4.0.13] - 2025-03-03
### Changed
- Update package dependencies. [#42163]

## [4.0.12] - 2025-02-24
### Changed
- Update dependencies. [#39855]

## [4.0.11] - 2025-02-17
### Changed
- Update dependencies. [#39855]

## [4.0.10] - 2025-02-11
### Changed
- Update dependencies. [#39855]

## [4.0.9] - 2025-02-10
### Changed
- Update package dependencies. [#41491] [#41577]

## [4.0.8] - 2025-02-03
### Changed
- Update package dependencies. [#41286]

## [4.0.7] - 2025-01-20
### Changed
- Code: Use function-style exit() and die() with a default status code of 0. [#41167]
- Updated package dependencies. [#41099]

## [4.0.6] - 2025-01-06
### Changed
- Updated package dependencies. [#40798] [#40812]

## [4.0.5] - 2024-12-16
### Changed
- Updated package dependencies. [#40564]

## [4.0.4] - 2024-12-09
### Changed
- Updated package dependencies. [#40363] [#40372]

## [4.0.3] - 2024-11-26
### Changed
- Update dependencies. [#39855]

## [4.0.2] - 2024-11-25
### Changed
- Updated dependencies. [#40286]
- Updated package dependencies. [#40288]

## [4.0.1] - 2024-11-18
### Changed
- Update dependencies. [#39855]

## [4.0.0] - 2024-11-14
### Added
- Backup: added next daily backup schedule time on admin page [#39914]

### Removed
- General: Update minimum PHP version to 7.2. [#40147]

## [3.4.17] - 2024-11-11
### Changed
- Updated package dependencies. [#39999] [#40060]

## [3.4.16] - 2024-11-04
### Added
- Enable test coverage. [#39961]

## [3.4.15] - 2024-10-21
### Changed
- Update dependencies. [#39781]

## [3.4.14] - 2024-10-14
### Changed
- Only include `wp-polyfill` as a script dependency when needed. [#39629]
- Updated package dependencies. [#39707]

## [3.4.13] - 2024-10-07
### Changed
- Updated package dependencies. [#39594]

## [3.4.12] - 2024-09-30
### Changed
- Update dependencies. [#39528]

## [3.4.11] - 2024-09-23
### Changed
- Update dependencies. [#38958]

## [3.4.10] - 2024-09-16
### Changed
- Updated package dependencies. [#39332]

### Fixed
- Remove unnecessary leading space from i18n message. [#39305]
- Stop considering discarded backups as successful backups on the admin page [#39385]

## [3.4.9] - 2024-09-10
### Changed
- Updated package dependencies. [#39302]

## [3.4.8] - 2024-09-09
### Changed
- Updated package dependencies. [#39278]

## [3.4.7] - 2024-09-05
### Changed
- Updated package dependencies. [#39176]

## [3.4.6] - 2024-09-02
### Changed
- Admin menu: change order of Jetpack sub-menu items [#39095]
- Updated package dependencies. [#39111]

## [3.4.5] - 2024-08-26
### Changed
- Updated package dependencies. [#39004]

## [3.4.4] - 2024-08-21
### Fixed
- Decoupled backup connection screens from useConnection hook to avoid unnecessary loading and prevent duplicated API calls. [#38948]
- Revert recent SVG image optimizations. [#38981]

## [3.4.3] - 2024-08-19
### Changed
- Update dependencies. [#38861] [#38662]

### Fixed
- Lossless image optimization for images (should improve performance with no visible changes). [#38750]

## [3.4.2] - 2024-07-22
### Changed
- Update dependencies. [#38402]

## [3.4.1] - 2024-07-08
### Changed
- Updated package dependencies. [#38132]

## [3.4.0] - 2024-06-27
### Added
- Add on-demand backups feature in the backup package [#37998]

## [3.3.17] - 2024-06-24
### Changed
- Update backup header cards layout for responsive design [#37944]

## [3.3.16] - 2024-06-17
### Changed
- Updated package dependencies. [#37796]

## [3.3.15] - 2024-06-10
### Changed
- Updated package dependencies. [#37669]

## [3.3.14] - 2024-06-03
### Changed
- Remove the 'jetpack-identity-crisis' dependency. [#36968]

## [3.3.13] - 2024-05-27
### Changed
- Update dependencies. [#37323]

## [3.3.12] - 2024-05-20
### Changed
- Updated package dependencies. [#37379] [#37380] [#37382]

## [3.3.11] - 2024-05-09
### Changed
- Update dependencies. [#37280]

## [3.3.10] - 2024-05-06
### Added
- Add missing package dependencies. [#37141]

### Changed
- Updated package dependencies. [#37147]

## [3.3.9] - 2024-04-25
### Changed
- Internal updates.

## [3.3.8] - 2024-04-22
### Changed
- Internal updates.

## [3.3.7] - 2024-04-15
### Changed
- Internal updates.

## [3.3.6] - 2024-04-08
### Changed
- Updated package dependencies. [#36760]

## [3.3.5] - 2024-04-01
### Changed
- Update dependencies. [#36655]

## [3.3.4] - 2024-03-27
### Changed
- Updated package dependencies. [#36585]

## [3.3.3] - 2024-03-25
### Fixed
- Backup: change some error messages to not trigger security scanners [#36496]

## [3.3.2] - 2024-03-18
### Changed
- Internal updates.

## [3.3.1] - 2024-03-12
### Changed
- Update dependencies. [#36243]
- Updated package dependencies. [#36325]

## [3.3.0] - 2024-03-04
### Added
- Add endpoint to query backup preflight checks [#36032]

### Changed
- Updated package dependencies.

### Fixed
- Real time backups: Fix getting more than one row in the related orders table [#36096]

## [3.2.0] - 2024-02-27
### Added
- Real time backups: Add endpoints orders to be used in real-time backups jetpack [#35649]

## [3.1.5] - 2024-02-13
### Changed
- Updated package dependencies. [#35608]

## [3.1.4] - 2024-02-08
### Fixed
- Write helper script to ABSPATH by default, just like we did before [#35508]

## [3.1.3] - 2024-02-07
### Changed
- Update dependencies. [#35520]

## [3.1.2] - 2024-02-05
### Changed
- Updated package dependencies.

## [3.1.1] - 2024-01-29
### Changed
- Update dependencies.

## [3.1.0] - 2024-01-22
### Changed
- Use blog ID instead site slug for checkout and WPCOM links. [#35020]

## [3.0.0] - 2024-01-04
### Fixed
- Backup: Add namespace versioning to Helper_Script_Manager and other classes [#34739]

## [2.0.5] - 2024-01-04
### Changed
- Updated package dependencies. [#34815] [#34816]

## [2.0.4] - 2023-12-20
### Changed
- Updated package dependencies. [#34694]

## [2.0.3] - 2023-12-13
### Fixed
- Backup: Bug fixes in helper script installation class. [#34297]

## [2.0.2] - 2023-12-11
### Changed
- Updated package dependencies. [#34416]

## [2.0.1] - 2023-12-03
### Changed
- Updated package dependencies. [#34411] [#34427]

## [2.0.0] - 2023-11-20
### Changed
- Updated required PHP version to >= 7.0. [#34192]

## [1.17.12] - 2023-11-14
### Changed
- Updated package dependencies. [#34093]

## [1.17.11] - 2023-11-13
### Changed
- Updated dependencies.

## [1.17.10] - 2023-11-03

## [1.17.9] - 2023-10-23
### Changed
- Replace Calypso progress bar with one from VideoPress. [#33054]
- Updated package dependencies. [#33646] [#33687]

## [1.17.8] - 2023-10-16
### Changed
- Updated package dependencies. [#33429]

## [1.17.7] - 2023-10-10
### Changed
- Updated package dependencies. [#33428]

## [1.17.6] - 2023-09-19
### Changed
- Updated Jetpack submenu sort order so individual features are alpha-sorted. [#32958]
- Updated package dependencies. [#33001]

## [1.17.5] - 2023-09-11
### Changed
- General: remove WP 6.1 backwards compatibility checks [#32772]

## [1.17.4] - 2023-09-04
### Changed
- Updated package dependencies. [#32803] [#32804]

## [1.17.3] - 2023-08-28
### Added
- Backup Admin: add backup file browser reference in the backup admin page [#32463]

## [1.17.2] - 2023-08-23
### Changed
- Updated package dependencies. [#32605]

## [1.17.1] - 2023-08-21
### Changed
- Use the new method to render Connection initial state. [#32499]

## [1.17.0] - 2023-08-14
### Added
- Add backup undo feature. [#32442]

## [1.16.6] - 2023-08-09
### Changed
- Updated package dependencies. [#32166]

## [1.16.5] - 2023-08-01
### Changed
- Minor internal updates.

## [1.16.4] - 2023-07-25
### Changed
- Updated package dependencies. [#32040]

## [1.16.3] - 2023-07-17
### Changed
- Updated package dependencies. [#31785]

## [1.16.2] - 2023-07-05
### Changed
- Updated package dependencies. [#31659]

## [1.16.1] - 2023-06-26
### Changed
- Updated package dependencies. [#31468]

## [1.16.0] - 2023-06-15
### Added
- Add testimonial component and use it on the backup connect screen [#31221]

## [1.15.0] - 2023-06-12
### Added
- Add "Why I need VaultPress Backup" section to connect page [#31285]
- Add video section to backup connect page [#31260]

## [1.14.0] - 2023-06-06
### Changed
- Update connection module to have an RNA option that updates the design [#31201]
- Updated package dependencies. [#31129]

## [1.13.0] - 2023-05-29
### Added
- Add connection screen for secondary admins [#30862]
- Add loading placeholder in backup dashboard while fetching capabilities and backup state. [#30972]

### Changed
- Add a loading placeholder while fetching backup plan when a secondary admin (not connected) is accessing the backup page. [#30963]

### Fixed
- Fix "Over storage space" message for sites with plans that have no storage limit [#30885]

## [1.12.17] - 2023-05-22
### Added
- Added backup storage help popover with forecast info [#30731]

## [1.12.16] - 2023-05-02
### Changed
- Updated package dependencies.

## [1.12.15] - 2023-05-01
### Changed
- Internal updates.

## [1.12.14] - 2023-04-25

- Minor internal updates.

## [1.12.13] - 2023-04-17
### Changed
- Updated package dependencies. [#30019]

## [1.12.12] - 2023-04-10
### Added
- Add Jetpack Autoloader package suggestion. [#29988]

## [1.12.11] - 2023-04-04
### Changed
- Updated package dependencies. [#29854]

## [1.12.10] - 2023-04-03
### Changed
- Internal updates.

## [1.12.9] - 2023-03-28
### Changed
- Minor internal updates.

## [1.12.8] - 2023-03-27
### Added
- (Backup, Boost, Search, Social) Add links on upgrade pages to activate a license key, if you already have one. [#29443]

### Fixed
- Backup: validate if storage details has loaded before attempting to fetch it again. [#29645]

## [1.12.7] - 2023-03-20
### Changed
- Updated package dependencies. [#29471]

## [1.12.6] - 2023-03-08
### Changed
- Switch to use tracking check from connection package [#29187]
- Updated package dependencies. [#29216]

## [1.12.5] - 2023-02-28
### Changed
- Update billing language [#29126]
- Update days of saved backups link to use external link instead of plain link. [#29137]

## [1.12.4] - 2023-02-20
### Changed
- Minor internal updates.

## [1.12.3] - 2023-02-15
### Changed
- Update to React 18. [#28710]

## [1.12.2] - 2023-02-08
### Added
- Add filter to redirect users who have a license to license activation page. [#28509]

### Changed
- Updated package dependencies. [#28682]

## [1.12.1] - 2023-01-30
### Added
- Add track event when user clicks on upgrade storage CTA [#28647]

## [1.12.0] - 2023-01-30
### Added
- Move usage storage level to a global state [#28603]

### Changed
- Backup storage details improvement [#28581]

## [1.11.0] - 2023-01-26
### Added
- Add backup storage UI on backup plugin [#28085]

## [1.10.8] - 2023-01-23
### Fixed
- Clean up JavaScript eslint issues. [#28441]
- Fixes the price display for products with intro offers for the first month. [#28424]

## [1.10.7] - 2023-01-11
### Added
- Setup js tests and add some tests to existing reducers, selectors and hooks [#28130]

### Changed
- Updated package dependencies. [#28127]
- Use `WP_Filesystem` more consistently in `Helper_Script_Manager`. [#28198]

## [1.10.6] - 2022-12-19
### Changed
- Update Backup logo [#27802]

### Fixed
- Update for PHP 8.2 deprecations. [#27949]

## [1.10.5] - 2022-12-06
### Changed
- Updated backup layout to improve consistency and remove redundancy. [#27222]
- Updated package dependencies. [#27340, #27688, #27696, #27697]

## [1.10.4] - 2022-11-28
### Changed
- Rename Jetpack Backup to Jetpack VaultPress Backup [#27432]
- Updated package dependencies. [#26069]

## [1.10.3] - 2022-11-14
### Changed
- Updated package dependencies. [#26930]

## [1.10.2] - 2022-11-07
### Changed
- Updated package dependencies.

### Fixed
- Updated how backup determines if the site has a plan. [#26943]

## [1.10.1] - 2022-11-01
### Changed
- Updated package dependencies. [#27196]

## [1.10.0] - 2022-10-25
### Changed
- Backup: add a new event to track when a customer dismisses a review request. [#26980]
- Updated package dependencies. [#26705]

### Fixed
- Stopped continuous state loading after good backup. [#27014]

## [1.9.2] - 2022-10-19
### Changed
- Updated package dependencies. [#26808]

## [1.9.1] - 2022-10-17
### Changed
- Updated package dependencies. [#26826, #26851]

## [1.9.0] - 2022-10-13
### Added
- Integrate the new connection error message React component into the Backup plugin. [#26545]

### Changed
- Updated package dependencies. [#26790]

## [1.8.4] - 2022-10-11
### Changed
- Updated package dependencies. [#26640, #26683]

## [1.8.3] - 2022-10-05
### Changed
- Updated package dependencies. [#26457]

## [1.8.2] - 2022-09-27
### Changed
- Updated package dependencies.

### Removed
- Removed dependency connection-ui [#26381]

### Fixed
- Do not show header footer on connection screen [#26421]
- Replace antippatern where components are returned from non-functionl components called renderSomething [#26411]

## [1.8.1] - 2022-09-20
### Changed
- Updated package dependencies.

### Fixed
- Allow other non owner admin to see Backup dashboard [#26105]

## [1.8.0] - 2022-09-08
### Added
- Add support for JITMs to Backup plugin [#25945]

### Changed
- Modify review request logic [#25979]
- Updated package dependencies.

### Fixed
- Backup: Fixed Automattic link in admin footer [#26075]

## [1.7.3] - 2022-08-30
### Changed
- Updated package dependencies. [#25694, #25814]

## [1.7.2] - 2022-08-23
### Changed
- Updated package dependencies. [#25338, #25339, #25377, #25628, #25665, #25762, #25764]

## [1.7.1] - 2022-08-09
### Changed
- Updated package dependencies. [#24477, #25265]

## [1.7.0] - 2022-08-03
### Changed
- Removed calls to deprecated components of the soft disconnect system as it is no longer in use. [#25315]
- Updated package dependencies. [#25300, #25315]

## [1.6.0] - 2022-07-26
### Added
- Add plugin review request [#24929]

### Changed
- Updated package dependencies. [#25140]

## [1.5.0] - 2022-07-19
### Changed
- Added page-view and link tracking analytics. [#24998]
- Updated package dependencies. [#25086]

## [1.4.3] - 2022-07-12
### Changed
- Make dashboard text more clear about realtime backups. [#24955]

## [1.4.2] - 2022-07-06
### Changed
- Updated package dependencies. [#24923]

## [1.4.1] - 2022-06-28
### Changed
- Updated package dependencies. [#24827]

## [1.4.0] - 2022-06-21
### Added
- Added UI to support backup warning state [#24680]

### Changed
- Renaming master to trunk. [#24661]
- Updated package dependencies. [#24679]

## [1.3.9] - 2022-06-14
### Changed
- Updated package dependencies. [#24529]

### Removed
- Removed extra headline from connection screen. [#24696]

## [1.3.8] - 2022-06-08
### Changed
- Reorder JS imports for `import/order` eslint rule. [#24601]
- Updated package dependencies. [#24510]

## [1.3.7] - 2022-05-31
### Changed
- Updated package dependencies. [#24432] [#24573] [#24475] [#24505] [#24515]

## [1.3.6] - 2022-05-24
### Changed
- Updated package dependencies. [#24396] [#24449] [#24453] [#24468]

## [1.3.5] - 2022-05-20
### Changed
- Improve the build process to ensure availability of built assets. [#24442]

## [1.3.4] - 2022-05-19
### Changed
- Updated package dependencies. [#24419]

## [1.3.3] - 2022-05-18
### Changed
- Changed method used to disconnect upon deactivation [#24300]
- Updated package dependencies. [#23795] [#24372] [#24153] [#24334] [#24347] [#24344]

### Fixed
- Fix new PHPCS sniffs. [#24366]

## [1.3.2] - 2022-05-10
### Changed
- Updated package dependencies. [#24167]

## [1.3.1] - 2022-05-04
### Changed
- Remove use of `pnpx` in preparation for pnpm 7.0. [#24210]
- Updated package dependencies. [#24095] [#24198]

## [1.3.0] - 2022-04-26
### Changed
- Backup plugin UI now lives in the Backup package

## [1.2.6] - 2022-04-19
### Changed
- Updated package dependencies.

## [1.2.5] - 2022-03-02
### Changed
- Updated package dependencies.

## [1.2.4] - 2022-02-22
### Changed
- Updated package dependencies.

## [1.2.3] - 2022-01-25
### Changed
- Dependency Update - Sync from 1.29 to 1.29

## [1.2.2] - 2022-01-18
### Changed
- Updated package dependencies.

## [1.2.1] - 2022-01-13
### Changed
- Updated package dependencies.

## [1.2.0] - 2022-01-04
### Changed
- Switch to pcov for code coverage.
- Updated package dependencies
- Updated package textdomain from `jetpack` to `jetpack-backup-pkg`.

## [1.1.11] - 2021-12-14
### Changed
- Updated package dependencies.

## [1.1.10] - 2021-11-30
### Changed
- Updated package dependencies.

## [1.1.9] - 2021-11-23
### Changed
- Updated package dependencies.

## [1.1.8] - 2021-11-02
### Changed
- Set `convertDeprecationsToExceptions` true in PHPUnit config.
- Update PHPUnit configs to include just what needs coverage rather than include everything then try to exclude stuff that doesn't.

## [1.1.7] - 2021-10-26
### Changed
- Updated package dependencies.

## [1.1.6] - 2021-10-13
### Changed
- Updated package dependencies.

## [1.1.5] - 2021-10-12
### Changed
- Updated package dependencies

## [1.1.4] - 2021-09-28
### Fixed
- Register WP hooks even if WP isn't loaded yet.

## [1.1.3] - 2021-08-31
### Changed
- Bump changelogger version
- Tests: update PHPUnit polyfills dependency (yoast/phpunit-polyfills).
- Updated package dependencies.

## [1.1.2] - 2021-08-12
### Added
- Add package version tracking.

## [1.1.1] - 2021-07-27
### Added
- Add a package version constant.

### Changed
- Updated package dependencies.

## [1.1.0] - 2021-06-29
### Added
- Add backup-helper-script endpoints under the jetpack/v4 namespace.
- Add backup real time endpoints.

## [1.0.6] - 2021-05-25
### Changed
- Updated package dependencies.

## [1.0.5] - 2021-04-27
### Changed
- Updated package dependencies.

## [1.0.4] - 2021-03-30
### Added
- Composer alias for dev-master, to improve dependencies

### Changed
- Update package dependencies.

## [1.0.3] - 2021-01-19

- Add mirror-repo information to all current composer packages
- Monorepo: Reorganize all projects

## [1.0.2] - 2019-11-08

- Packages: Use classmap instead of PSR-4

## 1.0.0 - 2019-10-29

- Add API endpoints and Jetpack Backup package for managing Help…

[4.2.44]: https://github.com/Automattic/jetpack-backup/compare/v4.2.43...v4.2.44
[4.2.43]: https://github.com/Automattic/jetpack-backup/compare/v4.2.42...v4.2.43
[4.2.42]: https://github.com/Automattic/jetpack-backup/compare/v4.2.41...v4.2.42
[4.2.41]: https://github.com/Automattic/jetpack-backup/compare/v4.2.40...v4.2.41
[4.2.40]: https://github.com/Automattic/jetpack-backup/compare/v4.2.39...v4.2.40
[4.2.39]: https://github.com/Automattic/jetpack-backup/compare/v4.2.38...v4.2.39
[4.2.38]: https://github.com/Automattic/jetpack-backup/compare/v4.2.37...v4.2.38
[4.2.37]: https://github.com/Automattic/jetpack-backup/compare/v4.2.36...v4.2.37
[4.2.36]: https://github.com/Automattic/jetpack-backup/compare/v4.2.35...v4.2.36
[4.2.35]: https://github.com/Automattic/jetpack-backup/compare/v4.2.34...v4.2.35
[4.2.34]: https://github.com/Automattic/jetpack-backup/compare/v4.2.33...v4.2.34
[4.2.33]: https://github.com/Automattic/jetpack-backup/compare/v4.2.32...v4.2.33
[4.2.32]: https://github.com/Automattic/jetpack-backup/compare/v4.2.31...v4.2.32
[4.2.31]: https://github.com/Automattic/jetpack-backup/compare/v4.2.30...v4.2.31
[4.2.30]: https://github.com/Automattic/jetpack-backup/compare/v4.2.29...v4.2.30
[4.2.29]: https://github.com/Automattic/jetpack-backup/compare/v4.2.28...v4.2.29
[4.2.28]: https://github.com/Automattic/jetpack-backup/compare/v4.2.27...v4.2.28
[4.2.27]: https://github.com/Automattic/jetpack-backup/compare/v4.2.26...v4.2.27
[4.2.26]: https://github.com/Automattic/jetpack-backup/compare/v4.2.25...v4.2.26
[4.2.25]: https://github.com/Automattic/jetpack-backup/compare/v4.2.24...v4.2.25
[4.2.24]: https://github.com/Automattic/jetpack-backup/compare/v4.2.23...v4.2.24
[4.2.23]: https://github.com/Automattic/jetpack-backup/compare/v4.2.22...v4.2.23
[4.2.22]: https://github.com/Automattic/jetpack-backup/compare/v4.2.21...v4.2.22
[4.2.21]: https://github.com/Automattic/jetpack-backup/compare/v4.2.20...v4.2.21
[4.2.20]: https://github.com/Automattic/jetpack-backup/compare/v4.2.19...v4.2.20
[4.2.19]: https://github.com/Automattic/jetpack-backup/compare/v4.2.18...v4.2.19
[4.2.18]: https://github.com/Automattic/jetpack-backup/compare/v4.2.17...v4.2.18
[4.2.17]: https://github.com/Automattic/jetpack-backup/compare/v4.2.16...v4.2.17
[4.2.16]: https://github.com/Automattic/jetpack-backup/compare/v4.2.15...v4.2.16
[4.2.15]: https://github.com/Automattic/jetpack-backup/compare/v4.2.14...v4.2.15
[4.2.14]: https://github.com/Automattic/jetpack-backup/compare/v4.2.13...v4.2.14
[4.2.13]: https://github.com/Automattic/jetpack-backup/compare/v4.2.12...v4.2.13
[4.2.12]: https://github.com/Automattic/jetpack-backup/compare/v4.2.11...v4.2.12
[4.2.11]: https://github.com/Automattic/jetpack-backup/compare/v4.2.10...v4.2.11
[4.2.10]: https://github.com/Automattic/jetpack-backup/compare/v4.2.9...v4.2.10
[4.2.9]: https://github.com/Automattic/jetpack-backup/compare/v4.2.8...v4.2.9
[4.2.8]: https://github.com/Automattic/jetpack-backup/compare/v4.2.7...v4.2.8
[4.2.7]: https://github.com/Automattic/jetpack-backup/compare/v4.2.6...v4.2.7
[4.2.6]: https://github.com/Automattic/jetpack-backup/compare/v4.2.5...v4.2.6
[4.2.5]: https://github.com/Automattic/jetpack-backup/compare/v4.2.4...v4.2.5
[4.2.4]: https://github.com/Automattic/jetpack-backup/compare/v4.2.3...v4.2.4
[4.2.3]: https://github.com/Automattic/jetpack-backup/compare/v4.2.2...v4.2.3
[4.2.2]: https://github.com/Automattic/jetpack-backup/compare/v4.2.1...v4.2.2
[4.2.1]: https://github.com/Automattic/jetpack-backup/compare/v4.2.0...v4.2.1
[4.2.0]: https://github.com/Automattic/jetpack-backup/compare/v4.1.2...v4.2.0
[4.1.2]: https://github.com/Automattic/jetpack-backup/compare/v4.1.1...v4.1.2
[4.1.1]: https://github.com/Automattic/jetpack-backup/compare/v4.1.0...v4.1.1
[4.1.0]: https://github.com/Automattic/jetpack-backup/compare/v4.0.22...v4.1.0
[4.0.22]: https://github.com/Automattic/jetpack-backup/compare/v4.0.21...v4.0.22
[4.0.21]: https://github.com/Automattic/jetpack-backup/compare/v4.0.20...v4.0.21
[4.0.20]: https://github.com/Automattic/jetpack-backup/compare/v4.0.19...v4.0.20
[4.0.19]: https://github.com/Automattic/jetpack-backup/compare/v4.0.18...v4.0.19
[4.0.18]: https://github.com/Automattic/jetpack-backup/compare/v4.0.17...v4.0.18
[4.0.17]: https://github.com/Automattic/jetpack-backup/compare/v4.0.16...v4.0.17
[4.0.16]: https://github.com/Automattic/jetpack-backup/compare/v4.0.15...v4.0.16
[4.0.15]: https://github.com/Automattic/jetpack-backup/compare/v4.0.14...v4.0.15
[4.0.14]: https://github.com/Automattic/jetpack-backup/compare/v4.0.13...v4.0.14
[4.0.13]: https://github.com/Automattic/jetpack-backup/compare/v4.0.12...v4.0.13
[4.0.12]: https://github.com/Automattic/jetpack-backup/compare/v4.0.11...v4.0.12
[4.0.11]: https://github.com/Automattic/jetpack-backup/compare/v4.0.10...v4.0.11
[4.0.10]: https://github.com/Automattic/jetpack-backup/compare/v4.0.9...v4.0.10
[4.0.9]: https://github.com/Automattic/jetpack-backup/compare/v4.0.8...v4.0.9
[4.0.8]: https://github.com/Automattic/jetpack-backup/compare/v4.0.7...v4.0.8
[4.0.7]: https://github.com/Automattic/jetpack-backup/compare/v4.0.6...v4.0.7
[4.0.6]: https://github.com/Automattic/jetpack-backup/compare/v4.0.5...v4.0.6
[4.0.5]: https://github.com/Automattic/jetpack-backup/compare/v4.0.4...v4.0.5
[4.0.4]: https://github.com/Automattic/jetpack-backup/compare/v4.0.3...v4.0.4
[4.0.3]: https://github.com/Automattic/jetpack-backup/compare/v4.0.2...v4.0.3
[4.0.2]: https://github.com/Automattic/jetpack-backup/compare/v4.0.1...v4.0.2
[4.0.1]: https://github.com/Automattic/jetpack-backup/compare/v4.0.0...v4.0.1
[4.0.0]: https://github.com/Automattic/jetpack-backup/compare/v3.4.17...v4.0.0
[3.4.17]: https://github.com/Automattic/jetpack-backup/compare/v3.4.16...v3.4.17
[3.4.16]: https://github.com/Automattic/jetpack-backup/compare/v3.4.15...v3.4.16
[3.4.15]: https://github.com/Automattic/jetpack-backup/compare/v3.4.14...v3.4.15
[3.4.14]: https://github.com/Automattic/jetpack-backup/compare/v3.4.13...v3.4.14
[3.4.13]: https://github.com/Automattic/jetpack-backup/compare/v3.4.12...v3.4.13
[3.4.12]: https://github.com/Automattic/jetpack-backup/compare/v3.4.11...v3.4.12
[3.4.11]: https://github.com/Automattic/jetpack-backup/compare/v3.4.10...v3.4.11
[3.4.10]: https://github.com/Automattic/jetpack-backup/compare/v3.4.9...v3.4.10
[3.4.9]: https://github.com/Automattic/jetpack-backup/compare/v3.4.8...v3.4.9
[3.4.8]: https://github.com/Automattic/jetpack-backup/compare/v3.4.7...v3.4.8
[3.4.7]: https://github.com/Automattic/jetpack-backup/compare/v3.4.6...v3.4.7
[3.4.6]: https://github.com/Automattic/jetpack-backup/compare/v3.4.5...v3.4.6
[3.4.5]: https://github.com/Automattic/jetpack-backup/compare/v3.4.4...v3.4.5
[3.4.4]: https://github.com/Automattic/jetpack-backup/compare/v3.4.3...v3.4.4
[3.4.3]: https://github.com/Automattic/jetpack-backup/compare/v3.4.2...v3.4.3
[3.4.2]: https://github.com/Automattic/jetpack-backup/compare/v3.4.1...v3.4.2
[3.4.1]: https://github.com/Automattic/jetpack-backup/compare/v3.4.0...v3.4.1
[3.4.0]: https://github.com/Automattic/jetpack-backup/compare/v3.3.17...v3.4.0
[3.3.17]: https://github.com/Automattic/jetpack-backup/compare/v3.3.16...v3.3.17
[3.3.16]: https://github.com/Automattic/jetpack-backup/compare/v3.3.15...v3.3.16
[3.3.15]: https://github.com/Automattic/jetpack-backup/compare/v3.3.14...v3.3.15
[3.3.14]: https://github.com/Automattic/jetpack-backup/compare/v3.3.13...v3.3.14
[3.3.13]: https://github.com/Automattic/jetpack-backup/compare/v3.3.12...v3.3.13
[3.3.12]: https://github.com/Automattic/jetpack-backup/compare/v3.3.11...v3.3.12
[3.3.11]: https://github.com/Automattic/jetpack-backup/compare/v3.3.10...v3.3.11
[3.3.10]: https://github.com/Automattic/jetpack-backup/compare/v3.3.9...v3.3.10
[3.3.9]: https://github.com/Automattic/jetpack-backup/compare/v3.3.8...v3.3.9
[3.3.8]: https://github.com/Automattic/jetpack-backup/compare/v3.3.7...v3.3.8
[3.3.7]: https://github.com/Automattic/jetpack-backup/compare/v3.3.6...v3.3.7
[3.3.6]: https://github.com/Automattic/jetpack-backup/compare/v3.3.5...v3.3.6
[3.3.5]: https://github.com/Automattic/jetpack-backup/compare/v3.3.4...v3.3.5
[3.3.4]: https://github.com/Automattic/jetpack-backup/compare/v3.3.3...v3.3.4
[3.3.3]: https://github.com/Automattic/jetpack-backup/compare/v3.3.2...v3.3.3
[3.3.2]: https://github.com/Automattic/jetpack-backup/compare/v3.3.1...v3.3.2
[3.3.1]: https://github.com/Automattic/jetpack-backup/compare/v3.3.0...v3.3.1
[3.3.0]: https://github.com/Automattic/jetpack-backup/compare/v3.2.0...v3.3.0
[3.2.0]: https://github.com/Automattic/jetpack-backup/compare/v3.1.5...v3.2.0
[3.1.5]: https://github.com/Automattic/jetpack-backup/compare/v3.1.4...v3.1.5
[3.1.4]: https://github.com/Automattic/jetpack-backup/compare/v3.1.3...v3.1.4
[3.1.3]: https://github.com/Automattic/jetpack-backup/compare/v3.1.2...v3.1.3
[3.1.2]: https://github.com/Automattic/jetpack-backup/compare/v3.1.1...v3.1.2
[3.1.1]: https://github.com/Automattic/jetpack-backup/compare/v3.1.0...v3.1.1
[3.1.0]: https://github.com/Automattic/jetpack-backup/compare/v3.0.0...v3.1.0
[3.0.0]: https://github.com/Automattic/jetpack-backup/compare/v2.0.5...v3.0.0
[2.0.5]: https://github.com/Automattic/jetpack-backup/compare/v2.0.4...v2.0.5
[2.0.4]: https://github.com/Automattic/jetpack-backup/compare/v2.0.3...v2.0.4
[2.0.3]: https://github.com/Automattic/jetpack-backup/compare/v2.0.2...v2.0.3
[2.0.2]: https://github.com/Automattic/jetpack-backup/compare/v2.0.1...v2.0.2
[2.0.1]: https://github.com/Automattic/jetpack-backup/compare/v2.0.0...v2.0.1
[2.0.0]: https://github.com/Automattic/jetpack-backup/compare/v1.17.12...v2.0.0
[1.17.12]: https://github.com/Automattic/jetpack-backup/compare/v1.17.11...v1.17.12
[1.17.11]: https://github.com/Automattic/jetpack-backup/compare/v1.17.10...v1.17.11
[1.17.10]: https://github.com/Automattic/jetpack-backup/compare/v1.17.9...v1.17.10
[1.17.9]: https://github.com/Automattic/jetpack-backup/compare/v1.17.8...v1.17.9
[1.17.8]: https://github.com/Automattic/jetpack-backup/compare/v1.17.7...v1.17.8
[1.17.7]: https://github.com/Automattic/jetpack-backup/compare/v1.17.6...v1.17.7
[1.17.6]: https://github.com/Automattic/jetpack-backup/compare/v1.17.5...v1.17.6
[1.17.5]: https://github.com/Automattic/jetpack-backup/compare/v1.17.4...v1.17.5
[1.17.4]: https://github.com/Automattic/jetpack-backup/compare/v1.17.3...v1.17.4
[1.17.3]: https://github.com/Automattic/jetpack-backup/compare/v1.17.2...v1.17.3
[1.17.2]: https://github.com/Automattic/jetpack-backup/compare/v1.17.1...v1.17.2
[1.17.1]: https://github.com/Automattic/jetpack-backup/compare/v1.17.0...v1.17.1
[1.17.0]: https://github.com/Automattic/jetpack-backup/compare/v1.16.6...v1.17.0
[1.16.6]: https://github.com/Automattic/jetpack-backup/compare/v1.16.5...v1.16.6
[1.16.5]: https://github.com/Automattic/jetpack-backup/compare/v1.16.4...v1.16.5
[1.16.4]: https://github.com/Automattic/jetpack-backup/compare/v1.16.3...v1.16.4
[1.16.3]: https://github.com/Automattic/jetpack-backup/compare/v1.16.2...v1.16.3
[1.16.2]: https://github.com/Automattic/jetpack-backup/compare/v1.16.1...v1.16.2
[1.16.1]: https://github.com/Automattic/jetpack-backup/compare/v1.16.0...v1.16.1
[1.16.0]: https://github.com/Automattic/jetpack-backup/compare/v1.15.0...v1.16.0
[1.15.0]: https://github.com/Automattic/jetpack-backup/compare/v1.14.0...v1.15.0
[1.14.0]: https://github.com/Automattic/jetpack-backup/compare/v1.13.0...v1.14.0
[1.13.0]: https://github.com/Automattic/jetpack-backup/compare/v1.12.17...v1.13.0
[1.12.17]: https://github.com/Automattic/jetpack-backup/compare/v1.12.16...v1.12.17
[1.12.16]: https://github.com/Automattic/jetpack-backup/compare/v1.12.15...v1.12.16
[1.12.15]: https://github.com/Automattic/jetpack-backup/compare/v1.12.14...v1.12.15
[1.12.14]: https://github.com/Automattic/jetpack-backup/compare/v1.12.13...v1.12.14
[1.12.13]: https://github.com/Automattic/jetpack-backup/compare/v1.12.12...v1.12.13
[1.12.12]: https://github.com/Automattic/jetpack-backup/compare/v1.12.11...v1.12.12
[1.12.11]: https://github.com/Automattic/jetpack-backup/compare/v1.12.10...v1.12.11
[1.12.10]: https://github.com/Automattic/jetpack-backup/compare/v1.12.9...v1.12.10
[1.12.9]: https://github.com/Automattic/jetpack-backup/compare/v1.12.8...v1.12.9
[1.12.8]: https://github.com/Automattic/jetpack-backup/compare/v1.12.7...v1.12.8
[1.12.7]: https://github.com/Automattic/jetpack-backup/compare/v1.12.6...v1.12.7
[1.12.6]: https://github.com/Automattic/jetpack-backup/compare/v1.12.5...v1.12.6
[1.12.5]: https://github.com/Automattic/jetpack-backup/compare/v1.12.4...v1.12.5
[1.12.4]: https://github.com/Automattic/jetpack-backup/compare/v1.12.3...v1.12.4
[1.12.3]: https://github.com/Automattic/jetpack-backup/compare/v1.12.2...v1.12.3
[1.12.2]: https://github.com/Automattic/jetpack-backup/compare/v1.12.1...v1.12.2
[1.12.1]: https://github.com/Automattic/jetpack-backup/compare/v1.12.0...v1.12.1
[1.12.0]: https://github.com/Automattic/jetpack-backup/compare/v1.11.0...v1.12.0
[1.11.0]: https://github.com/Automattic/jetpack-backup/compare/v1.10.8...v1.11.0
[1.10.8]: https://github.com/Automattic/jetpack-backup/compare/v1.10.7...v1.10.8
[1.10.7]: https://github.com/Automattic/jetpack-backup/compare/v1.10.6...v1.10.7
[1.10.6]: https://github.com/Automattic/jetpack-backup/compare/v1.10.5...v1.10.6
[1.10.5]: https://github.com/Automattic/jetpack-backup/compare/v1.10.4...v1.10.5
[1.10.4]: https://github.com/Automattic/jetpack-backup/compare/v1.10.3...v1.10.4
[1.10.3]: https://github.com/Automattic/jetpack-backup/compare/v1.10.2...v1.10.3
[1.10.2]: https://github.com/Automattic/jetpack-backup/compare/v1.10.1...v1.10.2
[1.10.1]: https://github.com/Automattic/jetpack-backup/compare/v1.10.0...v1.10.1
[1.10.0]: https://github.com/Automattic/jetpack-backup/compare/v1.9.2...v1.10.0
[1.9.2]: https://github.com/Automattic/jetpack-backup/compare/v1.9.1...v1.9.2
[1.9.1]: https://github.com/Automattic/jetpack-backup/compare/v1.9.0...v1.9.1
[1.9.0]: https://github.com/Automattic/jetpack-backup/compare/v1.8.4...v1.9.0
[1.8.4]: https://github.com/Automattic/jetpack-backup/compare/v1.8.3...v1.8.4
[1.8.3]: https://github.com/Automattic/jetpack-backup/compare/v1.8.2...v1.8.3
[1.8.2]: https://github.com/Automattic/jetpack-backup/compare/v1.8.1...v1.8.2
[1.8.1]: https://github.com/Automattic/jetpack-backup/compare/v1.8.0...v1.8.1
[1.8.0]: https://github.com/Automattic/jetpack-backup/compare/v1.7.3...v1.8.0
[1.7.3]: https://github.com/Automattic/jetpack-backup/compare/v1.7.2...v1.7.3
[1.7.2]: https://github.com/Automattic/jetpack-backup/compare/v1.7.1...v1.7.2
[1.7.1]: https://github.com/Automattic/jetpack-backup/compare/v1.7.0...v1.7.1
[1.7.0]: https://github.com/Automattic/jetpack-backup/compare/v1.6.0...v1.7.0
[1.6.0]: https://github.com/Automattic/jetpack-backup/compare/v1.5.0...v1.6.0
[1.5.0]: https://github.com/Automattic/jetpack-backup/compare/v1.4.3...v1.5.0
[1.4.3]: https://github.com/Automattic/jetpack-backup/compare/v1.4.2...v1.4.3
[1.4.2]: https://github.com/Automattic/jetpack-backup/compare/v1.4.1...v1.4.2
[1.4.1]: https://github.com/Automattic/jetpack-backup/compare/v1.4.0...v1.4.1
[1.4.0]: https://github.com/Automattic/jetpack-backup/compare/v1.3.9...v1.4.0
[1.3.9]: https://github.com/Automattic/jetpack-backup/compare/v1.3.8...v1.3.9
[1.3.8]: https://github.com/Automattic/jetpack-backup/compare/v1.3.7...v1.3.8
[1.3.7]: https://github.com/Automattic/jetpack-backup/compare/v1.3.6...v1.3.7
[1.3.6]: https://github.com/Automattic/jetpack-backup/compare/v1.3.5...v1.3.6
[1.3.5]: https://github.com/Automattic/jetpack-backup/compare/v1.3.4...v1.3.5
[1.3.4]: https://github.com/Automattic/jetpack-backup/compare/v1.3.3...v1.3.4
[1.3.3]: https://github.com/Automattic/jetpack-backup/compare/v1.3.2...v1.3.3
[1.3.2]: https://github.com/Automattic/jetpack-backup/compare/v1.3.1...v1.3.2
[1.3.1]: https://github.com/Automattic/jetpack-backup/compare/v1.3.0...v1.3.1
[1.3.0]: https://github.com/Automattic/jetpack-backup/compare/v1.2.6...v1.3.0
[1.2.6]: https://github.com/Automattic/jetpack-backup/compare/v1.2.5...v1.2.6
[1.2.5]: https://github.com/Automattic/jetpack-backup/compare/v1.2.4...v1.2.5
[1.2.4]: https://github.com/Automattic/jetpack-backup/compare/v1.2.3...v1.2.4
[1.2.3]: https://github.com/Automattic/jetpack-backup/compare/v1.2.2...v1.2.3
[1.2.2]: https://github.com/Automattic/jetpack-backup/compare/v1.2.1...v1.2.2
[1.2.1]: https://github.com/Automattic/jetpack-backup/compare/v1.2.0...v1.2.1
[1.2.0]: https://github.com/Automattic/jetpack-backup/compare/v1.1.11...v1.2.0
[1.1.11]: https://github.com/Automattic/jetpack-backup/compare/v1.1.10...v1.1.11
[1.1.10]: https://github.com/Automattic/jetpack-backup/compare/v1.1.9...v1.1.10
[1.1.9]: https://github.com/Automattic/jetpack-backup/compare/v1.1.8...v1.1.9
[1.1.8]: https://github.com/Automattic/jetpack-backup/compare/v1.1.7...v1.1.8
[1.1.7]: https://github.com/Automattic/jetpack-backup/compare/v1.1.6...v1.1.7
[1.1.6]: https://github.com/Automattic/jetpack-backup/compare/v1.1.5...v1.1.6
[1.1.5]: https://github.com/Automattic/jetpack-backup/compare/v1.1.4...v1.1.5
[1.1.4]: https://github.com/Automattic/jetpack-backup/compare/v1.1.3...v1.1.4
[1.1.3]: https://github.com/Automattic/jetpack-backup/compare/v1.1.2...v1.1.3
[1.1.2]: https://github.com/Automattic/jetpack-backup/compare/v1.1.1...v1.1.2
[1.1.1]: https://github.com/Automattic/jetpack-backup/compare/v1.1.0...v1.1.1
[1.1.0]: https://github.com/Automattic/jetpack-backup/compare/v1.0.6...v1.1.0
[1.0.6]: https://github.com/Automattic/jetpack-backup/compare/v1.0.5...v1.0.6
[1.0.5]: https://github.com/Automattic/jetpack-backup/compare/v1.0.4...v1.0.5
[1.0.4]: https://github.com/Automattic/jetpack-backup/compare/v1.0.3...v1.0.4
[1.0.3]: https://github.com/Automattic/jetpack-backup/compare/v1.0.2...v1.0.3
[1.0.2]: https://github.com/Automattic/jetpack-backup/compare/v1.0.0...v1.0.2
